//
//  ViewController.m
//  OneLoginExample
//
//  Created by 刘练 on 2019/3/20.
//  Copyright © 2019 geetest. All rights reserved.
//

#import "ViewController.h"
#import "LoginViewController.h"
#import "GOPAuthViewController.h"
#import "OLTermsHelper.h"

@interface ViewController ()

@property (weak, nonatomic) IBOutlet UIButton *nLoginButton;
@property (weak, nonatomic) IBOutlet UIButton *onepassButton;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    self.navigationItem.title = @"无感本机认证";
    self.nLoginButton.layer.masksToBounds = YES;
    self.nLoginButton.layer.cornerRadius = 5;
    self.onepassButton.layer.masksToBounds = YES;
    self.onepassButton.layer.cornerRadius = 5;
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    
    if (![OLTermsHelper  hasAcceptedTermsWithAlert:NO]) {
        [OLTermsHelper showTermsAlertFrom:self onAccept:nil];
    }
}

- (IBAction)nLoginAction:(id)sender {
    if (![OLTermsHelper hasAcceptedTermsWithAlert:YES]) {
        return;
    }
    
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:[NSBundle mainBundle]];
    LoginViewController *controller = [storyboard instantiateViewControllerWithIdentifier:@"NewLoginViewController"];
    if (controller) {
        [self.navigationController pushViewController:controller animated:YES];
    }
}

- (IBAction)onepassAction:(id)sender {
    if (![OLTermsHelper hasAcceptedTermsWithAlert:YES]) {
        return;
    }
    
    GOPAuthViewModel *model = [GOPAuthViewModel new];
    GOPAuthViewController *authViewController = [[GOPAuthViewController alloc] init];
    authViewController.authViewModel = model;
    [self.navigationController pushViewController:authViewController animated:YES];
}

@end
